<?php
session_start();

// 5 minutes in seconds
$expire_time = 5 * 60;

// Check if "last_activity" is set
if (isset($_SESSION['last_activity'])) {
    // Check the time since the last activity
    if (time() - $_SESSION['last_activity'] > $expire_time) {
        // User has been inactive for too long.
        session_unset(); // unset $_SESSION variable
        session_destroy(); // destroy session data
        header('Location: ../auth-login.php'); // redirect to login page
        exit();
    }
}

// Set last activity time for next check
$_SESSION['last_activity'] = time();

$companyId = $_SESSION['company_id'];

// Include your database connection file
include 'includes/dbconn.php';

// Initialize the variables
$totalRevenue = 0;
$salesAnalytics = 0;
$statistics = 0;

// Fetch total revenue
$totalRevenueQuery = "SELECT SUM(total_amount) AS total_revenue FROM invoices WHERE DATE(due_date) = CURDATE()";
$totalRevenueResult = $conn->query($totalRevenueQuery);
if ($totalRevenueResult && $totalRevenueResult->num_rows > 0) {
    $row = $totalRevenueResult->fetch_assoc();
    $totalRevenue = $row['total_revenue'];
}

// Fetch sales analytics data
$salesAnalyticsQuery = "SELECT SUM(total_amount) AS sales_today FROM invoices WHERE DATE(due_date) = CURDATE()";
$salesAnalyticsResult = $conn->query($salesAnalyticsQuery);
if ($salesAnalyticsResult && $salesAnalyticsResult->num_rows > 0) {
    $row = $salesAnalyticsResult->fetch_assoc();
    $salesAnalytics = $row['sales_today'];
}

// Fetch statistics
$statisticsQuery = "SELECT COUNT(*) AS total_sales FROM invoices WHERE DATE(due_date) = CURDATE()";
$statisticsResult = $conn->query($statisticsQuery);
if ($statisticsResult && $statisticsResult->num_rows > 0) {
    $row = $statisticsResult->fetch_assoc();
    $statistics = $row['total_sales'];
}

// Close the connection
$conn->close();
?>



<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Dashboard";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">


    <?php $pagetitle = "Dashboard"; include 'partials/menu.php';  ?>


    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">

                    <div class="col-xl-3 col-md-6">
                        <div class="card" data-section="sales">
                            <div class="card-body">
                                <div class="dropdown float-end">
                                    <a href="#" class="dropdown-toggle arrow-none card-drop" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="mdi mdi-dots-vertical"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <!-- Use classes instead of ids -->
                                        <a href="javascript:void(0);" class="dropdown-item sales-option">Daily</a>
                                        <a href="javascript:void(0);" class="dropdown-item sales-option">Weekly</a>
                                        <a href="javascript:void(0);" class="dropdown-item sales-option">Monthly</a>
                                    </div>

                                </div>
                                <h4 class="header-title mt-0 mb-4">Total Sales</h4>
                                <div class="widget-chart-1">
                                    <div class="widget-detail-1 text-end">
                                        <h2 class="fw-normal pt-2 mb-1"> <?php echo number_format((float)$totalRevenue, 2, '.', ''); ?> </h2>
                                        <p class="text-muted mb-1">Sales today</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                    <div class="col-xl-3 col-md-6">
                        <div class="card" data-section="expenses">
                            <div class="card-body">
                                <div class="dropdown float-end">
                                    <a href="#" class="dropdown-toggle arrow-none card-drop" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="mdi mdi-dots-vertical"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <!-- Use classes instead of ids -->
                                        <a href="javascript:void(0);" class="dropdown-item expenses-option">Daily</a>
                                        <a href="javascript:void(0);" class="dropdown-item expenses-option">Weekly</a>
                                        <a href="javascript:void(0);" class="dropdown-item expenses-option">Monthly</a>
                                    </div>
                                </div>
                                <h4 class="header-title mt-0 mb-3">Total Expenses</h4>
                                
                                <div class="widget-chart-1">
                                    <div class="widget-detail-1 text-end">
                                        <h2 class="fw-normal pt-2 mb-1"> <?php echo number_format((float)$totalExpenses, 2, '.', ''); ?> </h2>
                                        <p class="text-muted mb-1">Expenses today</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                    <div class="col-xl-3 col-md-6">
                        <div class="card" data-section="paid-invoices">
                            <div class="card-body">
                                <a href="#" class="dropdown-toggle arrow-none card-drop" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="mdi mdi-dots-vertical"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <!-- Use classes instead of ids -->
                                        <a href="javascript:void(0);" class="dropdown-item paid-invoices-option">Daily</a>
                                        <a href="javascript:void(0);" class="dropdown-item paid-invoices-option">Weekly</a>
                                        <a href="javascript:void(0);" class="dropdown-item paid-invoices-option">Monthly</a>
                                    </div>
                                <h4 class="header-title mt-0 mb-4">Paid Invoices</h4>

                                <div class="widget-chart-1">
                                    <div class="widget-detail-1 text-end">
                                        <h2 class="fw-normal pt-2 mb-1"> <?php echo number_format((float)$totalPaid, 2, '.', ''); ?> </h2>
                                        <p class="text-muted mb-1">Paid Invoices today</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                    <div class="col-xl-3 col-md-6">
                        <div class="card" data-section="unpaid-invoices">
                            <div class="card-body">
                                <a href="#" class="dropdown-toggle arrow-none card-drop" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="mdi mdi-dots-vertical"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <!-- Use classes instead of ids -->
                                        <a href="javascript:void(0);" class="dropdown-item unpaid-invoices-option">Daily</a>
                                        <a href="javascript:void(0);" class="dropdown-item unpaid-invoices-option">Weekly</a>
                                        <a href="javascript:void(0);" class="dropdown-item unpaid-invoices-option">Monthly</a>
                                    </div>
                                <h4 class="header-title mt-0 mb-3">Unpaid Invoices</h4>

                                <div class="widget-box-2">
                                    <div class="widget-detail-2 text-end">
                                        <h2 class="fw-normal mb-1"> <?php echo number_format((float)$totalUnpaid, 2, '.', ''); ?> </h2>
                                        <p class="text-muted mb-3">Unpaid Invoices today</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div><!-- end col -->

                </div>
                <!-- end row -->
                
                <div class="row">
                    
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="header-title">Chart of Accounts</h4>
        
                               <?php include 'display_coa.php'; ?>
        
                            </div> <!-- end card-body-->
                        </div>

                    </div><!-- end col -->

                </div>
                <!-- end row -->
                
                <div class="row">
                    
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="header-title">Latest Transactions</h4>
        
                               <?php include 'latest_transactions.php'; ?>
        
                            </div> <!-- end card-body-->
                        </div>

                    </div><!-- end col -->

                </div>
                <!-- end row -->

                
                <!-- end row -->

                

            </div> <!-- container-fluid -->

        </div> <!-- content -->

        <?php include 'partials/footer.php'; ?>

    </div>
    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php include 'partials/right-sidebar.php'; ?>

<?php include 'partials/footer-scripts.php'; ?>

<!-- knob plugin -->
<script src="assets/libs/jquery-knob/jquery.knob.min.js"></script>

<!--Morris Chart-->
<script src="assets/libs/morris.js06/morris.min.js"></script>
<script src="assets/libs/raphael/raphael.min.js"></script>

<!-- Dashboar init js-->
<script src="assets/js/pages/dashboard.init.js"></script>

<!-- App js-->
<script src="assets/js/app.min.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll('.dropdown-menu .dropdown-item').forEach(item => {
        item.addEventListener('click', function() {
            const period = this.textContent.trim().toLowerCase();
            const section = this.closest('.card').dataset.section;

            let endpoint = '';
            switch (section) {
                case 'sales':
                    endpoint = 'sales_data.php';
                    break;
                case 'expenses':
                    endpoint = 'expenses_data.php';
                    break;
                case 'paid-invoices':
                    endpoint = 'paid_invoices_data.php';
                    break;
                case 'unpaid-invoices':
                    endpoint = 'unpaid_invoices_data.php';
                    break;
                // Add more cases as needed
            }

            if (endpoint) {
                console.log(`Fetching data for ${section} - Period: ${period}`);
                fetchData(endpoint, period, section);
            } else {
                console.error(`No endpoint found for section: ${section}`);
            }
        });
    });
});

function fetchData(endpoint, period, section) {
    fetch(`${endpoint}?option=${period}`)
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            console.log('Data received:', data); // Log the data to inspect its structure
            if(data.total !== undefined) {
                const card = document.querySelector(`[data-section="${section}"]`);
                card.querySelector('.widget-detail-1 h2').textContent = `$${data.total}`;
                card.querySelector('.widget-detail-1 p').textContent = `Total ${period}`;
            } else {
                console.error('Total key is not present in the response');
                // Handle the absence of the 'total' key appropriately
            }
        })
        .catch(error => {
            console.error('Fetch Error:', error);
            // Implement user-visible error reporting
        });
}

</script>
<!--
<script>
    document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll('.dropdown-item').forEach(item => {
        item.addEventListener('click', function() {
            const period = this.textContent.trim().toLowerCase();
            fetchData('profit_loss_data.php', period);
        });
    });
});

function fetchData(endpoint, period) {
    fetch(`${endpoint}?option=${period}`)
        .then(response => response.json())
        .then(data => {
            // Assuming you have a function to update your Morris chart
            updateMorrisChart(data.profit, data.loss);
        })
        .catch(error => console.error('Error:', error));
}

function updateMorrisChart(profit, loss) {
    // Destroy the old chart instance if it exists
    if (window.myMorrisChart) {
        window.myMorrisChart.destroy();
    }

    // Create a new Morris Donut Chart
    window.myMorrisChart = new Morris.Donut({
        element: 'morris-donut-example',
        data: [
            {label: "Profit", value: profit},
            {label: "Loss", value: loss}
        ],
        colors: ['#5b69bc', '#ff8acc']
    });
}

</script>
-->
</body>

</html>